
const passInput = document.querySelector(".pas_box input"),
copyIcon = document.querySelector(".pas_box .copy_icon"),
rangeInput = document.querySelector(".range_box input"),
sliderNum = document.querySelector(".range_box .slider_num"),
generateButton = document.querySelector(".generate_button");

// All Characters
let allCharacters = 
"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789^!&$%|[]{}():;.,*+-#@<>~";

const generatePassword = () =>{
  let newPassword = "";

  for (let i = 0; i < rangeInput.value; i++){
    let randomIndex  = Math.floor(Math.random()* allCharacters.length);
    newPassword += allCharacters[randomIndex];
  }
  passInput.value = newPassword;
  copyIcon.classList.replace("fas", "far");
}

rangeInput.addEventListener("input", () => {
    sliderNum.innerText = rangeInput.value;
    generatePassword();
});

copyIcon.addEventListener("click", () => {
    navigator.clipboard.writeText(passInput.value);

    copyIcon.classList.replace("far", "fas");
});

generateButton.addEventListener("click", generatePassword);

generatePassword();